#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private PITrendReversalIndNT8[] cachePITrendReversalIndNT8;

		
		public PITrendReversalIndNT8 PITrendReversalIndNT8(string emailAddress, int emailFrequency)
		{
			return PITrendReversalIndNT8(Input, emailAddress, emailFrequency);
		}


		
		public PITrendReversalIndNT8 PITrendReversalIndNT8(ISeries<double> input, string emailAddress, int emailFrequency)
		{
			if (cachePITrendReversalIndNT8 != null)
				for (int idx = 0; idx < cachePITrendReversalIndNT8.Length; idx++)
					if (cachePITrendReversalIndNT8[idx].EmailAddress == emailAddress && cachePITrendReversalIndNT8[idx].EmailFrequency == emailFrequency && cachePITrendReversalIndNT8[idx].EqualsInput(input))
						return cachePITrendReversalIndNT8[idx];
			return CacheIndicator<PITrendReversalIndNT8>(new PITrendReversalIndNT8(){ EmailAddress = emailAddress, EmailFrequency = emailFrequency }, input, ref cachePITrendReversalIndNT8);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.PITrendReversalIndNT8 PITrendReversalIndNT8(string emailAddress, int emailFrequency)
		{
			return indicator.PITrendReversalIndNT8(Input, emailAddress, emailFrequency);
		}


		
		public Indicators.PITrendReversalIndNT8 PITrendReversalIndNT8(ISeries<double> input , string emailAddress, int emailFrequency)
		{
			return indicator.PITrendReversalIndNT8(input, emailAddress, emailFrequency);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.PITrendReversalIndNT8 PITrendReversalIndNT8(string emailAddress, int emailFrequency)
		{
			return indicator.PITrendReversalIndNT8(Input, emailAddress, emailFrequency);
		}


		
		public Indicators.PITrendReversalIndNT8 PITrendReversalIndNT8(ISeries<double> input , string emailAddress, int emailFrequency)
		{
			return indicator.PITrendReversalIndNT8(input, emailAddress, emailFrequency);
		}

	}
}

#endregion
