//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PI_BollingerInd[] cachePI_BollingerInd = null;

        private static PI_BollingerInd checkPI_BollingerInd = new PI_BollingerInd();

        /// <summary>
        /// PI_BollingerInd Bands are plotted at standard deviation levels above and below a moving average. Since standard deviation is a measure of volatility, the bands are self-adjusting: widening during volatile markets and contracting during calmer periods.
        /// </summary>
        /// <returns></returns>
        public PI_BollingerInd PI_BollingerInd(double numStdDev, int period)
        {
            return PI_BollingerInd(Input, numStdDev, period);
        }

        /// <summary>
        /// PI_BollingerInd Bands are plotted at standard deviation levels above and below a moving average. Since standard deviation is a measure of volatility, the bands are self-adjusting: widening during volatile markets and contracting during calmer periods.
        /// </summary>
        /// <returns></returns>
        public PI_BollingerInd PI_BollingerInd(Data.IDataSeries input, double numStdDev, int period)
        {
            if (cachePI_BollingerInd != null)
                for (int idx = 0; idx < cachePI_BollingerInd.Length; idx++)
                    if (Math.Abs(cachePI_BollingerInd[idx].NumStdDev - numStdDev) <= double.Epsilon && cachePI_BollingerInd[idx].Period == period && cachePI_BollingerInd[idx].EqualsInput(input))
                        return cachePI_BollingerInd[idx];

            lock (checkPI_BollingerInd)
            {
                checkPI_BollingerInd.NumStdDev = numStdDev;
                numStdDev = checkPI_BollingerInd.NumStdDev;
                checkPI_BollingerInd.Period = period;
                period = checkPI_BollingerInd.Period;

                if (cachePI_BollingerInd != null)
                    for (int idx = 0; idx < cachePI_BollingerInd.Length; idx++)
                        if (Math.Abs(cachePI_BollingerInd[idx].NumStdDev - numStdDev) <= double.Epsilon && cachePI_BollingerInd[idx].Period == period && cachePI_BollingerInd[idx].EqualsInput(input))
                            return cachePI_BollingerInd[idx];

                PI_BollingerInd indicator = new PI_BollingerInd();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.NumStdDev = numStdDev;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                PI_BollingerInd[] tmp = new PI_BollingerInd[cachePI_BollingerInd == null ? 1 : cachePI_BollingerInd.Length + 1];
                if (cachePI_BollingerInd != null)
                    cachePI_BollingerInd.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachePI_BollingerInd = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// PI_BollingerInd Bands are plotted at standard deviation levels above and below a moving average. Since standard deviation is a measure of volatility, the bands are self-adjusting: widening during volatile markets and contracting during calmer periods.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PI_BollingerInd PI_BollingerInd(double numStdDev, int period)
        {
            return _indicator.PI_BollingerInd(Input, numStdDev, period);
        }

        /// <summary>
        /// PI_BollingerInd Bands are plotted at standard deviation levels above and below a moving average. Since standard deviation is a measure of volatility, the bands are self-adjusting: widening during volatile markets and contracting during calmer periods.
        /// </summary>
        /// <returns></returns>
        public Indicator.PI_BollingerInd PI_BollingerInd(Data.IDataSeries input, double numStdDev, int period)
        {
            return _indicator.PI_BollingerInd(input, numStdDev, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// PI_BollingerInd Bands are plotted at standard deviation levels above and below a moving average. Since standard deviation is a measure of volatility, the bands are self-adjusting: widening during volatile markets and contracting during calmer periods.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PI_BollingerInd PI_BollingerInd(double numStdDev, int period)
        {
            return _indicator.PI_BollingerInd(Input, numStdDev, period);
        }

        /// <summary>
        /// PI_BollingerInd Bands are plotted at standard deviation levels above and below a moving average. Since standard deviation is a measure of volatility, the bands are self-adjusting: widening during volatile markets and contracting during calmer periods.
        /// </summary>
        /// <returns></returns>
        public Indicator.PI_BollingerInd PI_BollingerInd(Data.IDataSeries input, double numStdDev, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PI_BollingerInd(input, numStdDev, period);
        }
    }
}
#endregion
